import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET({ params }) {
  try {
    const id = parseInt(params.id);
    const [assignments] = await db.query('SELECT * FROM subjectAssignments WHERE id = ?', [id]);
    
    if (assignments.length === 0) {
      return json({ error: 'Penugasan mata pelajaran tidak ditemukan' }, { status: 404 });
    }
    
    return json({ success: true, data: assignments[0] });
  } catch (error) {
    console.error('Get subject assignment error:', error);
    return json({ error: 'Gagal mengambil data penugasan mata pelajaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function PUT({ params, request }) {
  try {
    const id = parseInt(params.id);
    const data = await request.json();
    const { studentId, subject, class: className, teacher } = data;

    if (!studentId || !subject) {
      return json({ error: 'ID Siswa dan Mata Pelajaran wajib diisi' }, { status: 400 });
    }

    await db.query(
      `UPDATE subjectAssignments 
       SET studentId = ?, subject = ?, class = ?, teacher = ?
       WHERE id = ?`,
      [studentId, subject.trim(), className || null, teacher || null, id]
    );

    return json({ success: true, message: 'Penugasan mata pelajaran berhasil diupdate' });
  } catch (error) {
    console.error('Update subject assignment error:', error);
    return json({ error: 'Gagal mengupdate penugasan mata pelajaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function DELETE({ params }) {
  try {
    const id = parseInt(params.id);
    await db.query('DELETE FROM subjectAssignments WHERE id = ?', [id]);
    return json({ success: true, message: 'Penugasan mata pelajaran berhasil dihapus' });
  } catch (error) {
    console.error('Delete subject assignment error:', error);
    return json({ error: 'Gagal menghapus penugasan mata pelajaran' }, { status: 500 });
  }
}
